<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MailSms extends Model 
{

    protected $table = 'mails_sms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'type', 'sujet', 'text', 'statut', 'id_entreprise', 'id_utilisateur');
    protected $visible = array('slug', 'type', 'sujet', 'text', 'statut', 'id_entreprise', 'id_utilisateur');

    public function entreprise()
    {
        return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
    }

    public function utilisateur()
    {
        return $this->belongsTo('App\Models\Utilisateur', 'id_utilisateur');
    }

}